-----------------------------------------------------------------------------------
USE AdventureWorksOBP
GO
-----------------------------------------------------------------------------------
-- Kreiranje pomone tablice
/*
Napravite tablicu Osoba s IDOsoba (PK i IDENTITY), Ime i Prezime.
*/
CREATE TABLE Osoba
(
    IDOsoba int PRIMARY KEY IDENTITY,
    Ime nvarchar(50),
    Prezime nvarchar(50)
)
GO
-----------------------------------------------------------------------------------
-- Zadatak 1.
/*
TRANSAKCIJE (1)
U transakciji umetnite 3 zapisa u Osoba i na kraju odustanite od transakcije.
*/
SELECT * FROM Osoba

BEGIN TRAN
	INSERT INTO Osoba VALUES ('Miro', 'Miri')
	INSERT INTO Osoba VALUES ('Ana', 'Ani')
	INSERT INTO Osoba VALUES ('Iva', 'Ivi')
	SELECT * FROM Osoba
ROLLBACK TRAN

SELECT * FROM Osoba
GO

-----------------------------------------------------------------------------------
-- Zadatak 2.
/*
TRANSAKCIJE (1)
U transakciji umetnite 3 zapisa u Osoba i na kraju potvrdite transakciju.
*/
SELECT * FROM Osoba

BEGIN TRAN
	INSERT INTO Osoba VALUES ('Miro', 'Miri')
	INSERT INTO Osoba VALUES ('Ana', 'Ani')
	INSERT INTO Osoba VALUES ('Iva', 'Ivi')
	SELECT * FROM Osoba
COMMIT TRAN

SELECT * FROM Osoba
GO

-----------------------------------------------------------------------------------
-- Zadatak 3.
/*
TRANSAKCIJE (1)
U transakciji umetnite 1 zapis u Osoba i postavite kontrolnu toku. 
Umetnite jo 1 zapis. 
Na kraju odustanite od transakcije.
*/

SELECT * FROM Osoba

DELETE Osoba

BEGIN TRAN
	INSERT INTO Osoba VALUES ('Miro', 'Miri')
	SAVE TRAN cp1
	INSERT INTO Osoba VALUES ('Ana', 'Ani')
	SELECT * FROM Osoba
ROLLBACK TRAN

SELECT * FROM Osoba
GO

-----------------------------------------------------------------------------------
-- Zadatak 4.
/*
TRANSAKCIJE (1)
U transakciji umetnite 1 zapis u Osoba i postavite kontrolnu toku. 
Umetnite jo 1 zapis. 
Na kraju potvrdite transakciju.
*/

SELECT * FROM Osoba

DELETE Osoba

BEGIN TRAN
	INSERT INTO Osoba VALUES ('Miro', 'Miri')
	SAVE TRAN cp1
	INSERT INTO Osoba VALUES ('Ana', 'Ani')
	SELECT * FROM Osoba
COMMIT TRAN

SELECT * FROM Osoba
GO

-----------------------------------------------------------------------------------
-- Zadatak 5.
/*
TRANSAKCIJE (2)
U transakciji umetnite 1 zapis u Osoba i postavite kontrolnu toku. 
Umetnite jo 1 zapis i postavite kontrolnu toku. 
Na kraju odustanite od transakcije.
*/
SELECT * FROM Osoba

DELETE Osoba

BEGIN TRAN
	INSERT INTO Osoba VALUES ('Miro', 'Miri')
	SAVE TRAN cp1
	INSERT INTO Osoba VALUES ('Ana', 'Ani')
	SAVE TRAN cp2
	SELECT * FROM Osoba
ROLLBACK TRAN

SELECT * FROM Osoba
GO

-----------------------------------------------------------------------------------
-- Zadatak 6.
/*
TRANSAKCIJE (2)
U transakciji umetnite 1 zapis u Osoba i postavite kontrolnu toku. 
Umetnite jo 1 zapis i postavite kontrolnu toku. 
Na kraju potvrdite transakciju.
*/
SELECT * FROM Osoba

DELETE Osoba

BEGIN TRAN
	INSERT INTO Osoba VALUES ('Miro', 'Miri')
	SAVE TRAN cp1
	INSERT INTO Osoba VALUES ('Ana', 'Ani')
	SAVE TRAN cp2
	SELECT * FROM Osoba
COMMIT TRAN

SELECT * FROM Osoba
GO

-----------------------------------------------------------------------------------
-- Zadatak 7.
/*
TRANSAKCIJE (2)
U transakciji umetnite 1 zapis u Osoba i postavite kontrolnu toku. 
Umetnite jo 1 zapis i vratite se na kontrolnu toku. 
Na kraju odustanite od transakcije.
*/
SELECT * FROM Osoba

DELETE Osoba

BEGIN TRAN
	INSERT INTO Osoba VALUES ('Miro', 'Miri')
	SAVE TRAN cp1
	INSERT INTO Osoba VALUES ('Ana', 'Ani')
	SELECT * FROM Osoba
	ROLLBACK TRAN cp1
	SELECT * FROM Osoba
ROLLBACK TRAN

SELECT * FROM Osoba
GO

-----------------------------------------------------------------------------------
-- Zadatak 8.
/*
TRANSAKCIJE (2)
U transakciji umetnite 1 zapis u Osoba i postavite kontrolnu toku. 
Umetnite jo 1 zapis i vratite se na kontrolnu toku. 
Na kraju potvrdite transakciju.
*/

SELECT * FROM Osoba

BEGIN TRAN
	INSERT INTO Osoba VALUES ('Miro', 'Miri')
	SAVE TRAN cp1
	INSERT INTO Osoba VALUES ('Ana', 'Ani')
	SELECT * FROM Osoba
	ROLLBACK TRAN cp1
	SELECT * FROM Osoba
COMMIT TRAN

SELECT * FROM Osoba
GO

DELETE Osoba

-----------------------------------------------------------------------------------
-- Zadatak 9.
/*
TRANSAKCIJE (3)
Napiite proceduru za brisanje drave. Neka procedura prima 1 parametar, IDDrzava. 
Transakciju vodite izvan procedure. 
Ispiite uspjeh ili neuspjeh. 
- Pozovite 3 puta proceduru s vrijednostima parametara jednakim 50, 51 i 52. 
- Pozovite 3 puta proceduru s vrijednostima parametara jednakim 50, 51 i 1.
*/
-- Napiite proceduru za brisanje drave. Neka procedura prima 1 parametar, IDDrzava. 
CREATE PROC p9
	@IDDrzava int
AS
DELETE FROM Drzava WHERE IDDrzava = @IDDrzava
GO
-- Transakciju vodite izvan procedure. 
-- Ispiite uspjeh ili neuspjeh. 
-- Pozovite 3 puta proceduru s vrijednostima parametara jednakim 50, 51 i 52. 
BEGIN TRY
	BEGIN TRAN
		EXEC p9 50
		EXEC p9 51
		EXEC p9 52
	COMMIT TRAN
	PRINT 'Brisanje uspjeno'
END TRY
BEGIN CATCH
	ROLLBACK TRAN
	PRINT 'Greka pri brisanju'
END CATCH
GO
-- Transakciju vodite izvan procedure. 
-- Ispiite uspjeh ili neuspjeh. 
-- Pozovite 3 puta proceduru s vrijednostima parametara jednakim 50, 51 i 1.
BEGIN TRY
	BEGIN TRAN
		EXEC p9 50
		EXEC p9 51
		EXEC p9 1
	COMMIT TRAN
	PRINT 'Brisanje uspjeno'
END TRY
BEGIN CATCH
	ROLLBACK TRAN
	PRINT 'Greka pri brisanju'
END CATCH
GO

-----------------------------------------------------------------------------------
-- Zadatak 10.
/*
TRANSAKCIJE (3)
Napiite proceduru s 3 parametra za brisanje triju drava. 
Transakciju vodite unutar procedure. 
Ispiite uspjeh ili neuspjeh. 
Pozovite proceduru s vrijednostima 50, 51 i 52. 
Pozovite proceduru s vrijednostima 50, 51 i 1.
*/
create PROC p10
	@IDDrzava1 int,
	@IDDrzava2 int,
	@IDDrzava3 int
AS
BEGIN TRY
	BEGIN TRAN
		DELETE FROM Drzava WHERE IDDrzava = @IDDrzava1
		DELETE FROM Drzava WHERE IDDrzava = @IDDrzava2
		DELETE FROM Drzava WHERE IDDrzava = @IDDrzava3
	COMMIT TRAN
	PRINT 'Brisanje uspjeno'
END TRY
BEGIN CATCH
	ROLLBACK TRAN
	PRINT 'Greka pri brisanju: '  + ERROR_MESSAGE()
END CATCH
GO
-- Pozovite proceduru s vrijednostima 50, 51 i 52. 
EXEC p10 50, 51, 52
-- Pozovite proceduru s vrijednostima 50, 51 i 1.
EXEC p10 50, 51, 1
GO

-----------------------------------------------------------------------------------
-- Zadatak 11.
/*
TRANSAKCIJE (4)
Unutar vanjske transakcije pozovite prethodnu proceduru s vrijednostima 50, 51 i 52. 
Nakon toga odustanite od vanjske transakcije. 
Ispiite uspjeh ili neuspjeh. 
Je li brisanje napravljeno?
*/
BEGIN TRY
	BEGIN TRAN
		EXEC p10 50, 51, 52
	ROLLBACK TRAN
	PRINT 'Sve OK, ali odustajem od transakcije'
END TRY
BEGIN CATCH
	ROLLBACK TRAN
	PRINT 'Desila se greka pa odustajem od transakcije'
END CATCH 
GO
----------------------------------------------------------------
----------------------------------------------------------------